<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:ns1="http://www.mf.gov.pl/SENT/2017/12/08/SENT_417.xsd"
    xmlns:tp="http://www.mf.gov.pl/SENT/2017/12/08/STypes.xsd">
  <xsl:template match="ns1:SENT_417">
    <!-- TODO: Auto-generated template -->
    <html>
      <head>
        <style>
          * {
          -webkit-print-color-adjust: exact !important;
          color-adjust: exact !important;
          }
          
          @media print {
          body {-webkit-print-color-adjust: exact;}
          }
          
          body {
          font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
          margin: 0 auto;
          padding: 0 auto;
          }
          
          .sent-xslt {
          border-collapse: initial;
          }
          
          .sent-xslt h1 {
          padding: 6px 4px 4px 10px;
          color:#000000;
          margin-top: 0;
          background-color:#c5c2c2;
          font-weight: normal;
          font-size: 12px;
          margin-bottom: 0;
          border-bottom: 1px solid #c8c9ca;
          }
          
          .sent-xslt .s1 {
          max-width: 1220px;
          border: 1px solid #c8c9ca;
          }
          
          .sent-xslt .t1 {
          position: relative;
          display: table;
          width: 100%;
          }
          
          .sent-xslt .grupName {
          font-size: 12px;
          margin: 0 !important;
          font-weight: bold;
          display:block;
          color: #000000;
          background-color:#dbddde;
          padding:5px 5px 5px 10px;
          border-top: 1px solid #dbddde;
          }
          
          .sent-xslt .element-1 {
          font-size: 12px;
          font-weight: normal;
          }
          
          .sent-xslt .element-2 {
          font-size: 14px;
          font-weight: normal;
          color: #008540;
          }
          
          .sent-xslt .grupInfo p {
          margin: 1px 0 1px 10px;
          font-weight: bold;
          font-size: 12px;
          }
          
          .sent-xslt .grupInfo {
          border-top: 1px solid #dbddde;
          }
          
          .sent-xslt .oilstatus {
          margin: 0 5px 0 -5px;
          margin: 2px 0 1px 10px;
          font-size: 14px;
          padding-bottom: 12px;
          color: red;
          }
          
          .sent-xslt .info1 {
          width: 50%;
          float: left;
          display: table-cell;
          padding: 4px 0px;
          }
          
          .sent-xslt .lang ul {
          margin: 0 auto;
          padding: 0;
          }
          
          .sent-xslt .lang ul li {
          display: inline;
          margin-left: 10px;
          }
          
          .sent-xslt .table {
          display: table;
          width: 99%;
          margin: 4px 0 15px 7px;
          border-spacing: 0 0;
          border-top: 1px solid #999999;
          border-left: 1px solid #999999;
          }
          
          .sent-xslt .table-header {
          font-size: 11px;
          font-weight: bold;
          padding: 5px;
          background-color: #ececec;
          border-bottom: 1px solid #999999;
          border-right: 1px solid #999999;
          }
          
          .sent-xslt .table-element {
          font-size: 12px;
          font-weight: normal;
          padding: 2px 5px;
          border-bottom: 1px solid #999999;
          border-right: 1px solid #999999;
          }
          
          .sent-xslt .table-element2 {
          font-size: 12px;
          font-weight: normal;
          padding: 0;
          border-bottom: 1px solid #999999;
          border-right: 1px solid #999999;
          }
          
          .sent-xslt .table-element3 {
          font-size: 12px;
          font-weight: bold;
          border: 1px #999999;
          border-top-style: solid;
          margin: 0;
          }
          
          .sent-xslt .table-element p {
          margin-left: 0;
          }
          
          .sent-xslt .table-element3 p {
          margin-left: 0;
          padding: 0px 5px;
          }
        
        </style>
      </head>
      <body>
        <div class="sent-xslt">
          <section class="sent-xslt s1">
            <h1>SENT417 - INFORMACJA O STATUSIE REJESTRACJI PODMIOTU OLEJOWEGO ORAZ URZĄDZEŃ GRZEWCZYCH</h1>
            <div class="sent-xslt t1">
              <p class="sent-xslt grupName">INFORMACJE DOTYCZĄCE ZAPYTANIA</p>
              <div class="sent-xslt t1">
                <div class="sent-xslt grupInfo">
                  <xsl:if test="ns1:ResponseInfo/ns1:SourceDocumentId !=''">
                    <div class="sent-xslt info1">
                      <p>
                        <span class="sent-xslt element-1">Numer własny zgłoszenia:</span>
                        <xsl:value-of select="ns1:ResponseInfo/ns1:SourceDocumentId"/>
                      </p>
                    </div>
                  </xsl:if>
                  <div class="sent-xslt info1">
                    <p>
                      <span class="sent-xslt element-1">Suma kontrolna:</span>
                      <xsl:value-of select="ns1:ResponseInfo/ns1:ChecksumOfSourceDocument"/>
                    </p>
                  </div>
                </div>
              </div>
            </div>
            <div class="sent-xslt t1">
              <p class="sent-xslt grupName">STATUS REJESTRACJI PODMIOTU OLEJOWEGO</p>
              <div class="sent-xslt grupInfo">
                <div class="sent-xslt info">
                  <p>
                    <xsl:value-of select="ns1:OilEntityIdentityType"/>: <xsl:value-of select="ns1:OilEntityIdentityNumber"/>
                  </p>
                </div>
              </div>
              <div class="sent-xslt grupInfo">
                <div class="sent-xslt info1">
                  <p>
                    <span class="sent-xslt element-1">Pośredniczący podmiot olejowy: </span>
                    <xsl:choose>
                      <xsl:when test="ns1:IsBroker = 'true'">
                        <input style="vertical-align:middle" type="checkbox" onclick="return false;" checked=""/>
                      </xsl:when>
                      <xsl:when test="ns1:IsBroker = 'false'">
                        <input style="vertical-align:middle" type="checkbox" onclick="return false;"/>
                      </xsl:when>
                    </xsl:choose>
                  </p>
                </div>
                <div class="sent-xslt info1">
                  <p>
                    <span class="sent-xslt element-1">Zużywający podmiot olejowy: </span>
                    <xsl:choose>
                      <xsl:when test="ns1:IsConsumer = 'true'">
                        <input style="vertical-align:middle" type="checkbox" onclick="return false;" checked=""/>
                      </xsl:when>
                      <xsl:when test="ns1:IsConsumer = 'false'">
                        <input style="vertical-align:middle" type="checkbox" onclick="return false;"/>
                      </xsl:when>
                    </xsl:choose>
                  </p>
                </div>
              </div>
            </div>
            <div class="sent-xslt t1">
              <p class="sent-xslt grupName">STATUS URZĄDZEŃ GRZEWCZYCH</p>
              <div class="sent-xslt grupInfo">
                <div class="sent-xslt info">
                  <xsl:if test="ns1:OilHeatingAddress !=''">
                    <table class="sent-xslt table" style='width: 440px'>
                      <tr>
                        <td class="sent-xslt table-header" style='width: 15px'>
                          <span>Lp.</span>
                        </td>
                        <td class="sent-xslt table-header" style='width: 320px'>
                          <span>Numer identyfikacyjny miejsca (adresu)</span>
                        </td>
                        <td class="sent-xslt table-header" style='width: 120px'>
                          <span>Status</span>
                        </td>
                      </tr>
                      <xsl:for-each select="ns1:OilHeatingAddress">
                        <tr>
                          <td class="sent-xslt table-element">
                            <span class="sent-xslt element-1">
                              <xsl:value-of select='position()'/>.
                            </span>
                          </td>
                          <td class="sent-xslt table-element">
                            <span class="sent-xslt element-1">
                              <xsl:value-of select="ns1:OilHeatingAddressId"/>
                            </span>
                          </td>
                          <td class="sent-xslt table-element">
                            <span class="sent-xslt element-1">
                              <xsl:choose>
                                <xsl:when test="ns1:IsRegistered ='true'">
                                  <span>zarejestrowany</span>
                                </xsl:when>
                                <xsl:when test="ns1:IsRegistered ='false'">
                                  <span>niezarejestrowany</span>
                                </xsl:when>
                              </xsl:choose>
                            </span>
                          </td>
                        </tr>
                      </xsl:for-each>
                    </table>
                  </xsl:if>
                  <xsl:if test="ns1:OilMobileDevice !=''">
                    <table class="sent-xslt table" style='width: 440px'>
                      <tr>
                        <td class="sent-xslt table-header" style='width: 15px'>
                          <span>Lp.</span>
                        </td>
                        <td class="sent-xslt table-header" style='width: 320px'>
                          <span>Numer identyfikacyjny urządzenia grzewczego</span>
                        </td>
                        <td class="sent-xslt table-header" style='width: 120px'>
                          <span>Status</span>
                        </td>
                      </tr>
                      <xsl:for-each select="ns1:OilMobileDevice">
                        <tr>
                          <td class="sent-xslt table-element">
                            <span class="sent-xslt element-1">
                              <xsl:value-of select='position()'/>.
                            </span>
                          </td>
                          <td class="sent-xslt table-element">
                            <span class="sent-xslt element-1">
                              <xsl:value-of select="ns1:OilMobileDeviceId"/>
                            </span>
                          </td>
                          <td class="sent-xslt table-element">
                            <span class="sent-xslt element-1">
                              <xsl:choose>
                                <xsl:when test="ns1:IsRegistered ='true'">
                                  <span>zarejestrowany</span>
                                </xsl:when>
                                <xsl:when test="ns1:IsRegistered ='false'">
                                  <span>niezarejestrowany</span>
                                </xsl:when>
                              </xsl:choose>
                            </span>
                          </td>
                        </tr>
                      </xsl:for-each>
                    </table>
                  </xsl:if>
                </div>
              </div>
            </div>
          </section>
        </div>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>